%% ********** RQS *************
% Version: 0.1
% Rail Quasi Statics (RQS) is intended for researchers from both academia
% and the industrie. It 'simulates' the run of a train over a given track
% with a given speed profile. 
%% ********** Possible output ******
% * Lateral forces of per axle (important for track shift)
% * Y/Q the derailment ratio (compare with Nadal's criterion)
% * DQ/Q the wheel unoading (often a limnit of 0.5 is accepted)
% * The forces in the couplers
% * The angles in the couplers
%% ********* The algorith accounts for: *******
% * Lateral forces due to centrifugal forces and gravity
% * Lateral forces due to the yaw angle rate (derived from the track
%   curvature)
% * Lateral forces due to the couplers (through the couplers angle, see publication below)
% * Vertical forces due to centrifugal forces and gravity
% * Vertical forces due to car body pitch (due to traction, coupler and
%   acceleration forces). 
% * Vertical forces due to bogie pitch (hereby the inertia of the bogie is
%   ignored, but the traction forces on the wheels and the traction rods are
%   accounted for)
% ** Each (distance) step of the calculation the accelerations are
% calculated again based on the track and vehicle profile accounting for
% the phenomena mentioned above. Within each step all acceleration are
% assumed to constant: the quasi static approach.
%% ********** How to run the calculation **************
% 1.  Run RQS_input.m to create an input file for RQS: see example below.
% 2a. With Matlab: run RQS_0_1.m  
% 2b. Without a Matlab license: contact me, there might be a solution.
% 3.  Analyse and try to improve the world's railway systems.
% 4.  When publishing do not forget to cite
%% ********** Disclaimer *********
% *  Although the software has been created with care the author does not
%    accept any consequences resulting from possible coding errors. 
% *  This is an amateur software and as such it has not been made fool
%    proof
% *  I am open for feed back, both for bug notices as for suggestions for
%    improvement/expansion. But please be aware my time is limited and that
%    I cannot fulfil all your wishes ;)
% *  If you write me, please use a clear email subject and state your name,
%    country, institution/company and purpose.
%% ********** Credits **********
%When using this software for publications, please cite: 
%Burgelman, Nico, Zili Li, and Rolf Dollevoet. 
%"Fast estimation of the derailment risk of a braking train in curves and turnouts." 
%International journal of heavy vehicle systems 23.3 (2016): 213-229.

%Made by Nico Burgelman (nicoburgelman@gmail.com), August 2016

clear

% ** Everything in SI-units!!
% ** DO NOT CHANGE THE NAMES OF THE VARIABLES BELOW, but do change the
% values



%% =======General input=======
filename='example';  %choose any appropriate filename for you calculation
IN.g=9.81;
%% =======Trackmodel==========
% ** Position along track, curvature, cant, velocity leading vehicle (at centre of mass)
IN.s=   [0  50  51    80    81 200 250   600   650 900];
IN.curv=[0  0   1/195 1/195 0  0   1/500 1/500 0   0]; 
IN.cant=[0  0   0.00  0.00  0  0   0.05  0.05  0   0]; %[m]
IN.tw=1.5; %track width [m]

IN.direct_v=0;             %if 1 use the speed profile directly, irrespective of the resultant tractive forces, if 0 see each speed as a new maximum speed. RQS will automatically slow down before a new lower speed limit and speed up after a new higher speed limit. The traction force is defined below.
IN.s_v= [0  350  800  900];
IN.v=   [40 80   70   70]/3.6; %[m/s]

IN.ds=0.5;  %distance step
%% ======Train model=========
% mass of each wagon [kg]
IN.m=[80000 50000 50000];
% number of axles per wagon (2 or 4):
IN.na=4;
%yaw inertia (moment of inertia around vertical axis) [kg m^2]
IN.I=[3 2 2]*1e6;
% which vehicle is responsible for traction and braking (if multiple: the
% traction/braking is divided proportinally with the vehicle mass)
IN.tb=[1];
% Total available traction/braking force [N]
IN.tf=200000;  %not used when IN.direct_v=1
% height of centre of mass above railtop
IN.h=[1.9 1.9 1.9];
% Length from buffer to buffer
IN.l=[26 20 20];
% bogie spacing
IN.b_s=[18 14 14];
% length from coupler rotation point to coupler end (in case of buffer and
% chain: longitudinal length between rotation point pull rod and buffer end)
IN.d=[0.5 0.5 0.5];
% coupler height (pullrod hight in case of buffer and chain)
IN.hc=[1 1 1];
% buffer and chain: 0 is no, 1 is yes
IN.bch=[0 0 0]; %not used in the current version of the software
% buffer height  (only used for bufer and chain)
IN.hb=[1 1 1];  %not used in the current version of the software
%height of the traction rod
IN.h_tr=[0.5 0.5 0.5];  %not used if IN.na=2
%wheelbase
IN.wb=[1.6 1.6 1.6];    %not used if IN.na=2
%% =========Output selection==========
% 0 is do not plot, 1 is do plot
%Derailment
OUT.YQ=1;                    %derailment coefficient (max for left an right wheel, so also situations with cant excess are included)
OUT.DQQ=1;                   %wheelunloading (max for left an right wheel, so also situations with cant excess are included)
OUT.Y=1;                     %lateral wheelset forces (absolute value)
OUT.mn=[1 2 3];              %number(s) of the vehicle of which the derailment coefficient and/or the unloading coefficient has to be plotted
OUT.cpl_force=1;             %coupler forces
OUT.cpl_angle=1;             %coupler angles
OUT.cn=[1 2];                %number(s) of the coupling of which the anhgle and/or the force has to be plotted
OUT.save_figures=0;          %saves the requested figures as .fig (for matlab use), .eps (for latex) and .emf (for word/powerpoint). It is saved under a name starting with the filename defined above.

OUT.s=1;                    %=1: plots as function of position on track
OUT.t=1;                    %=1: plots as function of time
%% =========Save input data===========
save(filename);
